
//	=================================================================
//	ADDON.H						21-09-2001 Arttu Soininen
//
//	Structure definitions for TerraScan addon modules.
//	=================================================================

//	Internal/UOR point

typedef struct {
	long	x ;
	long	y ;
	long	z ;
} Point3d ;

//	Master unit/meter point

typedef struct {
	double	x ;
	double	y ;
	double	z ;
} Dp3d ;

//	Echo values in ScanPnt

#define ECHO_ONLY		0
#define ECHO_FIRST		1
#define ECHO_INTER		2
#define ECHO_LAST		3

//	Point class

typedef struct {
	int		Class ;			//	Class number 0-255
	char	Desc[32] ;		//	Description
	char	Reserved[28] ;
} PntCls ;

#define CLASS_ANY		(9999)
#define SCANNER_ANY		(9999)

//	Command specification

typedef struct {
	char	MenuText[40] ;	//	Text to appear in pulldown menu
	int		UseFence ;		//	1=may use fence - tscan marks points, 0=no fence usage
	int		UseSelect ;		//	1=may use selected element, 0=no selection usage
	char	Reserved[200];	//	For future expansion
} AddCmd ;

//	Link to TerraScan tables

typedef struct {
	int		LnkSize ;		//	sizeof(AddLnk)
	int		LnkVersion ;	//	Structure version date (now 20110125)

	//	Currently loaded laser points

	INT64	*PntCnt ;		//	Number of laser points
	INT64	*PntMax ;		//	Allocation size of tables
	Point3d	**PntTbl ;		//	Laser points or NULL
	BYTE	**ClsTbl ;		//	Point classes or NULL
	BYTE	**BitTbl ;		//	Class bits 0-3, channel 4-5, direction 6, edge 7
	BYTE	**MrkTbl ;		//	Mark values or NULL
	BYTE	**FlgTbl ;		//	Flag values or NULL
	USHORT	**IntTbl ;		//	Intensity values or NULL
	USHORT	**LinTbl ;		//	Line numbers or NULL
	double	**DblTbl ;		//	Double time stamps or NULL
	short	**AngTbl ;		//	Scanner angles or NULL
	BYTE	**EchTbl ;		//	Echo bits or NULL
	USHORT	**ClrTbl ;		//	Point color values or NULL
	BYTE	**ScrTbl ;		//	Scanner numbers or NULL
	short	**LenTbl ;		//	Echo lengths or NULL
	char	**EnmTbl ;		//	Echo normality or NULL
	int		**DstTbl ;		//	Distance values or NULL
	UINT	**GrpTbl ;		//	Group identifiers or NULL
	UINT	**NrmTbl ;		//	Normal vectors or NULL
	USHORT	**PrmTbl ;		//	Parameter values or NULL
	BYTE	**DrwTbl ;		//	Drawing colors or NULL

	//	Active point classes

	int		PtcCnt ;		//	Number of point classes
	PntCls	*PtcTbl ;		//	Point classes

	//	Design file coordinate system, see IpToDp() and DpToIp()

	int		Units ;			//	Units per meter = subpermast * uorpersub
	int		ChlCnt ;		//	Number of channels in ClrTbl[], usually 3
	double	OrgX ;			//	Global origin
	double	OrgY ;
	double	OrgZ ;
} AddLnk ;

//	State information when command is run

typedef struct {
	int		SetSize ;		//	sizeof(AddSet)
	int		SetVersion ;	//	Structure version date (now 20071218, old 20010921)

	//	Parent window

	void	*MainWin ;		//	Main MicroStation window (HWND)

	//	Fence information

	int		Fenced ;		//	-1=not requested, 0=no fence, 1=points inside fence marked Mark=1

	//	Selected element

	Dp3d	*SelPts ;		//	Stroked first selected element or NULL
	int		SelCnt ;		//	Number of vertices

	//	Following fields can be used by macro commands

	char	Cmd[40] ;		//	Command name, for example "ResetEcho"
	char	Unparsed[400];	//	Unparsed parameters, for example "5 0.25"
	char	BlkFile[400] ;	//	Full path to active block file ("\0" if no active block)
	char	ActFile[400] ;	//	Full path to active file if running macro on selected files
} AddSet ;

//	Return bit mask from command

#define ARET_REDRAW		1	/* Points modified */

//	Link variable change notification

#define AFLG_POINTCOUNT	1	/* Point count has changed */
#define AFLG_CLASSES	2	/* Classes have changed */
#define AFLG_DESIGN		4	/* New design file */
#define AFLG_MACRO		8	/* Call before executing macro addon step */

